/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.pet_cemetery.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.pet_cemetery.client.renderer.entity.UndeadParrotRenderer;
import com.teamabnormals.pet_cemetery.core.registry.PCEntityTypes;
import net.minecraft.client.model.ParrotModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class UndeadParrotOnShoulderLayer<T extends Player>
extends RenderLayer<T, PlayerModel<T>> {
    private final ParrotModel parrotModel;

    public UndeadParrotOnShoulderLayer(RenderLayerParent<T, PlayerModel<T>> rendererIn, EntityModelSet modelSet) {
        super(rendererIn);
        this.parrotModel = new ParrotModel(modelSet.m_171103_(ModelLayers.f_171203_));
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.renderParrot(matrixStackIn, bufferIn, packedLightIn, entity, limbSwing, limbSwingAmount, netHeadYaw, headPitch, true);
        this.renderParrot(matrixStackIn, bufferIn, packedLightIn, entity, limbSwing, limbSwingAmount, netHeadYaw, headPitch, false);
    }

    private void renderParrot(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float netHeadYaw, float headPitch, boolean leftShoulderIn) {
        CompoundTag nbt = leftShoulderIn ? entity.m_36331_() : entity.m_36332_();
        EntityType.m_20632_((String)nbt.m_128461_("id")).filter(type -> type == PCEntityTypes.ZOMBIE_PARROT.get() || type == PCEntityTypes.SKELETON_PARROT.get()).ifPresent(type -> {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(leftShoulderIn ? (double)0.4f : (double)-0.4f, entity.m_6047_() ? (double)-1.3f : -1.5, 0.0);
            VertexConsumer vertexConsumer = bufferIn.m_6299_(this.parrotModel.m_103119_(type == PCEntityTypes.ZOMBIE_PARROT.get() ? UndeadParrotRenderer.ZOMBIE_PARROT_TEXTURE : UndeadParrotRenderer.SKELETON_PARROT_TEXTURE));
            this.parrotModel.m_103223_(matrixStackIn, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, limbSwing, limbSwingAmount, netHeadYaw, headPitch, entity.f_19797_);
            matrixStackIn.m_85849_();
        });
    }
}

